;;; Configurating a PC (minimum version)


;;; The goal is to configure a PC based on the needs of the 
;;; user.


;;; Template for Specifications

(deftemplate spec
	(multislot os (type SYMBOL)
		(allowed-symbols linux solaris win98 winNT))
	(slot role (type SYMBOL) 
		(allowed-symbols home-pc server workstation ))
	(multislot apps (type SYMBOL) 
		(allowed-symbols office CAD games 
				 VIDEO multimedia music-composing accounting)) 
	(slot network (type SYMBOL) 
		(allowed-symbols no lan telephone))
	(slot sound (type SYMBOL) 
		(allowed-symbols yes no ))
)



;;; Template for Configuration
(deftemplate config
	(slot CPU (type SYMBOL) (default UNKNOWN) )
	(slot HDD-type (type SYMBOL) 
		(allowed-symbols SCSI EIDE UNKNOWN) (default UNKNOWN))
	(slot HDD-capacity (type INTEGER))
	(slot RAM (type INTEGER))
	(multislot other-storage-devices (type SYMBOL) 
		(allowed-symbols CD DVD CD-RW UNKNOWN) (default UNKNOWN))
	(slot printer-type (type SYMBOL)
		(allowed-symbols laser ink-jet dot-matrix UNKNOWN) 
		(default UNKNOWN))
	(slot connectivity (type SYMBOL) 
		(allowed-symbols network-card modem nothing UNKNOWN) 
		(default UNKNOWN))
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Checking the specification Validity
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defrule check-net
	(context check-spec)
	(spec (role server) (network no))
	=> 
	(printout t " Wrong Specification: The role of the machine is to act as" crlf)
	(printout t " a SERVER but there is no network interface specified. Halting." crlf)
	(halt)
)



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; configure-CPU context
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defrule configure-CPU
	(context configure-CPU)
	?con<-(config (CPU UNKNOWN))
	(spec (apps $?apps))
	(test (subset (create$ CAD games) $?apps))
	=>
	(modify ?con (CPU Pentium-II))
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; configure-HDD context
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defrule configure-HDD-SCSI
	(context configure-HDD)
	(spec (role server))
	?con <- (config (HDD-type UNKNOWN))
	=>
	(modify ?con (HDD-type SCSI))
)


(defrule configure-HDD-IDE
	(context configure-HDD)
	(spec (role home-pc))
	?con <- (config (HDD-type UNKNOWN))
	=>
	(modify ?con (HDD-type EIDE))
)

(defrule configure-HDD-workstation
	(context configure-HDD)
	(spec (role workstation) (apps $?apps))
	?con <- (config (HDD-type UNKNOWN))
	=>
	(if (subset (create$ VIDEO) $?apps) then
		(bind ?type SCSI) else (bind ?type EIDE))
	(modify ?con (HDD-type ?type))
)


(defrule configure-HDD-capacity
	(context configure-HDD)
	(spec (role server) (os ?os))
	?con <- (config (HDD-capacity 0))
	(test (or (eq ?os winNT) (eq ?os linux)))
	=> 
	(modify ?con (HDD-capacity 4000))
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; configure RAM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defrule configure-ram
	(context configure-RAM)
	(spec (role server))
	?con <- (config (RAM 0))
	=>
	(modify ?con (RAM 128))
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; configure-other 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defrule lan
	(context configure-other)
	(spec (network lan))
	?con <- (config (connectivity UNKNOWN))
	=>
	(modify ?con (connectivity network-card))
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Rules for switching the context
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defrule change-context
	(declare (salience -10))
	?c <- (context check-spec)
	=> 
	(retract ?c)
	(assert (context configure-CPU))
)

(defrule CPU-disk-context
	(declare (salience -10))
	(not (config (CPU UNKNOWN)))
	?c <- (context configure-CPU)
	=> 
	(retract ?c)
	(assert (context configure-HDD))
)

(defrule disk-RAM-context
	(declare (salience -10))
	(not (config (HDD-type UNKNOWN) (HDD-capacity 0)))
	?c <- (context configure-HDD)
	=> 
	(retract ?c)
	(assert (context configure-RAM))
)

(defrule RAM-other-context
	(declare (salience -10))
	(not (config (RAM 0)))
	?c <- (context configure-RAM)
	=> 
	(retract ?c)
	(assert (context configure-other))
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Initial rule 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defrule initial
	(initial-fact)
	=> 
	(assert (context check-spec))
)

;;; initial fact
(deffacts spec-1
	(spec	(role server) (network lan) 
		(os winNT) (apps VIDEO CAD games))
	(config)
)
	


